/*global define */
/*jslint white: true */

/*
	AudibleItem:

	This object provides a mixin for each audible item.
*/

define  ([  "src/utils",	"src/build/treeAmount"],
function(   utils,			treeAmount) {
	'use strict';

	function AudibleItem() {
		utils.assert(this !== undefined, "AudibleItem not called with new.");
		// do not modify these private members directly or notifiers won't be called correctly
		this.pAudibleItem = { 
			enabled			: true, 
			volume			: 1, //% 0 to +inf
			disabledVolume	: undefined
		};
	}

	var ta = treeAmount({ 
		enabledLabel		: "enabled",
		amountLabel			: "volume",
		disabledAmountLabel	: "disabledVolume",
		changeNotifierType	: "audibleChanged",
		rename				: {	setAmount : "setVolume",
								getAmount : "getVolume",
								getEffectiveAmount : "getEffectiveVolume",
								getAmountToRoot : "getVolumeToRoot",
								isRelevant : "isAudible",
								getEnabled : "getAudibleEnabled",
								setEnabled : "setAudibleEnabled" },
		getTreeInfo : function (obj) {
			return obj.pAudibleItem;
		}
	});

	utils.mixin(AudibleItem, ta);

	utils.mixin(AudibleItem, {
		clone : function (clone_children, other) {
			var result = other;

			if (result) {
				// init
				AudibleItem.call(result);
			} else {
				// alloc and init
				result = new AudibleItem();
			}

			utils.clone(false, result.pAudibleItem, this.pAudibleItem);

			return result;
		}
	});
	
	return AudibleItem;
});
